﻿<%@ import Namespace="Soneta.Kasa" %>
<%@ Import Namespace="Soneta.Types" %>
<%@ Import Namespace="Soneta.Business" %>
<%@ Import Namespace="Soneta.Core" %>
<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Page language="c#" AutoEventWireup="false" codePage="1200" %>
<%@ Register TagPrefix="cc1" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<HTML>
	<HEAD>
		<title>Przelew poziomy</title>
		<script runat="server">	
		
            static readonly bool pusty1w = true;
	        static readonly bool pusty2w = false;
            static readonly int maxRightLen = 53;
            string nazwa;
            string adres;

            void OnContextLoad(object sender, EventArgs args) {
                CoreModule core = CoreModule.GetInstance(dc);
                this.nazwa = core.Config.Firma.Pieczątka.NazwaSkrócona;
                this.adres = core.Config.Firma.AdresSiedziby.ToString();
                
                ArrayList należności = new ArrayList();
                IDokumentPlatny dokument = (IDokumentPlatny)dc[typeof(IDokumentPlatny)];
                foreach (Platnosc płatność in dokument.Platnosci)
                    if (płatność is Naleznosc && (płatność.SposobZaplaty.Odroczony || płatność.TerminDni >= 0))
                        należności.Add(płatność);
                DataRepeater1.DataSource = należności;
            }

            protected void DataRepeater1_BeforeRow(object sender, EventArgs e) {
                Naleznosc należność = (Naleznosc)DataRepeater1.CurrentRow;
                string ss = należność.EwidencjaSP.Rachunek.Numer.ToString();
                rachunekOdbiorcy1.EditValue = ss;
                rachunekOdbiorcy2.EditValue = ss;
                rachunekOdbiorcy3.EditValue = ss;
                rachunekOdbiorcy4.EditValue = ss;

                string n1, n2;

                if (pusty1w) {
                    n1 = "";
                    n2 = this.nazwa + ", " + this.adres;
                }
                else {
                    n1 = this.nazwa;
                    n2 = this.adres;
                }
                odbiorca11.EditValue = Soneta.Core.Tools.Left(n1, maxRightLen);
                odbiorca12.EditValue = Soneta.Core.Tools.Left(n2, maxRightLen);
                odbiorca31.EditValue = Soneta.Core.Tools.Left(n1, maxRightLen);
                odbiorca32.EditValue = Soneta.Core.Tools.Left(n2, maxRightLen);

                if (pusty2w) {
                    n1 = "";
                    n2 = this.nazwa + ", " + this.adres;
                }
                else {
                    n1 = this.nazwa;
                    n2 = this.adres;
                }
                odbiorca21.EditValue = Soneta.Core.Tools.Left(n1, maxRightLen);
                odbiorca22.EditValue = Soneta.Core.Tools.Left(n2, maxRightLen);
                odbiorca41.EditValue = Soneta.Core.Tools.Left(n1, maxRightLen);
                odbiorca42.EditValue = Soneta.Core.Tools.Left(n2, maxRightLen);

                n1 = należność.Podmiot.Nazwa;
                n2 = należność.Podmiot.Adres.ToString();
                nadawca11.EditValue = Soneta.Core.Tools.Left(n1, maxRightLen);
                nadawca12.EditValue = Soneta.Core.Tools.Left(n2, maxRightLen);
                nadawca21.EditValue = Soneta.Core.Tools.Left(n1, maxRightLen);
                nadawca22.EditValue = Soneta.Core.Tools.Left(n2, maxRightLen);
                nadawca31.EditValue = Soneta.Core.Tools.Left(n1, maxRightLen);
                nadawca32.EditValue = Soneta.Core.Tools.Left(n2, maxRightLen);
                nadawca41.EditValue = Soneta.Core.Tools.Left(n1, maxRightLen);
                nadawca42.EditValue = Soneta.Core.Tools.Left(n2, maxRightLen);

                opis11.EditValue = Soneta.Core.Tools.Left(należność.Opis, maxRightLen);
                opis12.EditValue = Soneta.Core.Tools.Sub(należność.Opis, maxRightLen);
                opis21.EditValue = Soneta.Core.Tools.Left(należność.Opis, maxRightLen);
                opis22.EditValue = Soneta.Core.Tools.Sub(należność.Opis, maxRightLen);
                opis31.EditValue = Soneta.Core.Tools.Left(należność.Opis, maxRightLen);
                opis32.EditValue = Soneta.Core.Tools.Sub(należność.Opis, maxRightLen);
                opis41.EditValue = Soneta.Core.Tools.Left(należność.Opis, maxRightLen);
                opis42.EditValue = Soneta.Core.Tools.Sub(należność.Opis, maxRightLen);
            }

            string Format(int maxlines, int maxlen, params string[] args) {
                string ss = "";
                for (int i = 0; i < args.Length; i++) {
                    string sn = args[i].Trim();
                    if (sn != "")
                        if (ss == "")
                            ss = sn;
                        else
                            ss += " " + sn;
                }
                string result = "";
                int n = 0;
                for (int i = 0; i < ss.Length; i += maxlen) {
                    string sn = i + 30 <= ss.Length ? ss.Substring(i, maxlen) : ss.Substring(i, ss.Length - i);
                    if (result == "")
                        result = sn;
                    else
                        result += "<br>" + sn;
                    if (++n == maxlines)
                        break;
                }

                return result;
            }

		</script>
		<meta content="Microsoft Visual Studio 7.0" name="GENERATOR">
		<meta content="C#" name="CODE_LANGUAGE">
		<meta content="JavaScript" name="vs_defaultClientScript">
		<meta content="http://schemas.microsoft.com/intellisense/ie5" name="vs_targetSchema">
	</HEAD>
	<body>
		<form id="PrzelewPoziomy" method="post" runat="server">
			<ea:datacontext id="dc" runat="server" oncontextload="OnContextLoad" TypeName="Soneta.Kasa.IDokumentPlatny,Soneta.Kasa"
				Landscape="True" LeftMargin="2"></ea:datacontext>
			<ea:datarepeater id="DataRepeater1" runat="server" OnBeforeRow="DataRepeater1_BeforeRow" RowTypeName="Soneta.Kasa.Naleznosc,Soneta.Kasa"
				Width="100%" Height="161px" DataMember="Platnosci">
				<ea:SectionMarker id="SectionMarker9" runat="server"></ea:SectionMarker>
				<ea:PageBreak id="PageBreak1" runat="server" BreakFirstTimes="False"></ea:PageBreak>
				<TABLE id="Table1" cellSpacing="0" cellPadding="0" border="0">
					<TR>
						<TD style="WIDTH: 150mm; HEIGHT: 103mm" vAlign="top">
							<TABLE id="Table2" cellSpacing="0" cellPadding="0" border="0" style="WIDTH: 135mm">
								<TR>
									<TD style="HEIGHT: 6mm" vAlign="top">
										<ea:DataLabel id="odbiorca11" runat="server" Bold="False"></ea:DataLabel></TD>
								</TR>
								<TR>
									<TD style="HEIGHT: 8.5mm" vAlign="top">
										<ea:DataLabel id="odbiorca12" runat="server" Bold="False" DESIGNTIMEDRAGDROP="930"></ea:DataLabel></TD>
								</TR>
								<TR>
									<TD style="HEIGHT: 8.5mm" vAlign="top">
										<ea:DataLabel id="rachunekOdbiorcy1" runat="server" Bold="False"></ea:DataLabel>
									</TD>
								</TR>
								<TR>
									<TD vAlign="middle">
										<TABLE id="Table4" cellSpacing="0" cellPadding="0" border="0">
											<TR>
												<TD style="WIDTH: 45mm; HEIGHT: 8.5mm"></TD>
												<TD style="WIDTH: 30mm" vAlign="top"><STRONG></STRONG></TD>
												<TD style="WIDTH: 60mm" vAlign="top">
													<ea:DataLabel id="DataLabel4" runat="server" Bold="False" DataMember="Kwota"></ea:DataLabel></TD>
											</TR>
										</TABLE>
									</TD>
								</TR>
								<TR>
									<TD style="HEIGHT: 8.5mm" vAlign="top">
										<ea:DataLabel id="rachunekNadawcy1" runat="server" Bold="False"></ea:DataLabel>
									</TD>
								</TR>
								<TR>
									<TD style="HEIGHT: 8.5mm" vAlign="top">
										<ea:DataLabel id="nadawca11" runat="server" Bold="False" DESIGNTIMEDRAGDROP="961"></ea:DataLabel></TD>
								</TR>
								<TR>
									<TD style="HEIGHT: 8.5mm" vAlign="top">
										<ea:DataLabel id="nadawca12" runat="server" Bold="False"></ea:DataLabel></TD>
								</TR>
								<TR>
									<TD style="HEIGHT: 8.5mm" vAlign="top">
										<ea:DataLabel id="opis11" runat="server" Bold="False"></ea:DataLabel></TD>
								</TR>
								<TR>
									<TD style="HEIGHT: 8.5mm" vAlign="top">
										<ea:DataLabel id="opis12" runat="server" Bold="False" DESIGNTIMEDRAGDROP="970"></ea:DataLabel></TD>
								</TR>
								<TR>
									<TD vAlign="top" style="HEIGHT: 1mm">
										<ea:DataLabel id="data1" runat="server" Bold="False"></ea:DataLabel></TD>
									<TD style="HEIGHT: 5.82mm" vAlign="bottom"></TD>
								</TR>
							</TABLE>
						</TD>
						<TD vAlign="top" style="WIDTH: 135mm">
							<TABLE id="Table3" style="WIDTH: 135mm" cellSpacing="0" cellPadding="0" border="0">
								<TR>
									<TD style="HEIGHT: 6mm" vAlign="top">
										<ea:DataLabel id="odbiorca31" runat="server" Bold="False"></ea:DataLabel></TD>
								</TR>
								<TR>
									<TD style="HEIGHT: 8.5mm" vAlign="top">
										<ea:DataLabel id="odbiorca32" runat="server" Bold="False" DESIGNTIMEDRAGDROP="930"></ea:DataLabel></TD>
								</TR>
								<TR>
									<TD style="HEIGHT: 8.5mm" vAlign="top">
										<ea:DataLabel id="rachunekOdbiorcy3" runat="server" Bold="False"></ea:DataLabel></TD>
								</TR>
								<TR>
									<TD vAlign="middle">
										<TABLE id="Table5" cellSpacing="0" cellPadding="0" border="0">
											<TR>
												<TD style="WIDTH: 45mm; HEIGHT: 8.5mm"></TD>
												<TD style="WIDTH: 30mm" vAlign="top"><STRONG></STRONG></TD>
												<TD style="WIDTH: 60mm" vAlign="top">
													<ea:DataLabel id="DataLabel17" runat="server" Bold="False" DataMember="Kwota"></ea:DataLabel></TD>
											</TR>
										</TABLE>
									</TD>
								</TR>
								<TR>
									<TD style="HEIGHT: 8.5mm" vAlign="top">
										<ea:DataLabel id="rachunekNadawcy3" runat="server" Bold="False"></ea:DataLabel></TD>
								</TR>
								<TR>
									<TD style="HEIGHT: 8.5mm" vAlign="top">
										<ea:DataLabel id="nadawca31" runat="server" Bold="False" DESIGNTIMEDRAGDROP="961"></ea:DataLabel></TD>
								</TR>
								<TR>
									<TD style="HEIGHT: 8.5mm" vAlign="top">
										<ea:DataLabel id="nadawca32" runat="server" Bold="False"></ea:DataLabel></TD>
								</TR>
								<TR>
									<TD style="HEIGHT: 8.5mm" vAlign="top">
										<ea:DataLabel id="opis31" runat="server" Bold="False"></ea:DataLabel></TD>
								</TR>
								<TR>
									<TD style="HEIGHT: 8.5mm" vAlign="top">
										<ea:DataLabel id="opis32" runat="server" Bold="False" DESIGNTIMEDRAGDROP="970"></ea:DataLabel></TD>
								</TR>
								<TR>
									<TD style="HEIGHT: 1mm" vAlign="top">
										<ea:DataLabel id="data3" runat="server" Bold="False"></ea:DataLabel></TD>
									<TD style="HEIGHT: 5.82mm" vAlign="bottom"></TD>
								</TR>
							</TABLE>
						</TD>
					</TR>
					<TR>
						<TD vAlign="top">
							<TABLE id="Table6" style="WIDTH: 135mm" cellSpacing="0" cellPadding="0" border="0">
								<TR>
									<TD style="HEIGHT: 8.5mm" vAlign="top">
										<ea:DataLabel id="odbiorca21" runat="server" Bold="False"></ea:DataLabel></TD>
								</TR>
								<TR>
									<TD style="HEIGHT: 8.5mm" vAlign="top">
										<ea:DataLabel id="odbiorca22" runat="server" Bold="False" DESIGNTIMEDRAGDROP="930"></ea:DataLabel></TD>
								</TR>
								<TR>
									<TD style="HEIGHT: 8.5mm" vAlign="top">
										<ea:DataLabel id="rachunekOdbiorcy2" runat="server" Bold="False"></ea:DataLabel></TD>
								</TR>
								<TR>
									<TD vAlign="middle">
										<TABLE id="Table7" cellSpacing="0" cellPadding="0" border="0">
											<TR>
												<TD style="WIDTH: 45mm; HEIGHT: 8.5mm"></TD>
												<TD style="WIDTH: 30mm" vAlign="top"><STRONG></STRONG></TD>
												<TD style="WIDTH: 60mm" vAlign="top">
													<ea:DataLabel id="DataLabel27" runat="server" Bold="False" DataMember="Kwota"></ea:DataLabel></TD>
											</TR>
										</TABLE>
									</TD>
								</TR>
								<TR>
									<TD style="HEIGHT: 8.5mm" vAlign="top">
										<ea:DataLabel id="rachunekNadawcy2" runat="server" Bold="False"></ea:DataLabel></TD>
								</TR>
								<TR>
									<TD style="HEIGHT: 8.5mm" vAlign="top">
										<ea:DataLabel id="nadawca21" runat="server" Bold="False" DESIGNTIMEDRAGDROP="961"></ea:DataLabel></TD>
								</TR>
								<TR>
									<TD style="HEIGHT: 8.5mm" vAlign="top">
										<ea:DataLabel id="nadawca22" runat="server" Bold="False"></ea:DataLabel></TD>
								</TR>
								<TR>
									<TD style="HEIGHT: 8.5mm" vAlign="top">
										<ea:DataLabel id="opis21" runat="server" Bold="False"></ea:DataLabel></TD>
								</TR>
								<TR>
									<TD style="HEIGHT: 8.5mm" vAlign="top">
										<ea:DataLabel id="opis22" runat="server" Bold="False" DESIGNTIMEDRAGDROP="970"></ea:DataLabel></TD>
								</TR>
								<TR>
									<TD style="HEIGHT: 1mm" vAlign="top">
										<ea:DataLabel id="data2" runat="server" Bold="False"></ea:DataLabel></TD>
									<TD style="HEIGHT: 3.68mm" vAlign="bottom"></TD>
								</TR>
							</TABLE>
						</TD>
						<TD vAlign="top">
							<TABLE id="Table8" style="WIDTH: 135mm" cellSpacing="0" cellPadding="0" border="0">
								<TR>
									<TD style="HEIGHT: 8.5mm" vAlign="top">
										<ea:DataLabel id="odbiorca41" runat="server" Bold="False"></ea:DataLabel></TD>
								</TR>
								<TR>
									<TD style="HEIGHT: 8.5mm" vAlign="top">
										<ea:DataLabel id="odbiorca42" runat="server" Bold="False" DESIGNTIMEDRAGDROP="930"></ea:DataLabel></TD>
								</TR>
								<TR>
									<TD style="HEIGHT: 8.5mm" vAlign="top">
										<ea:DataLabel id="rachunekOdbiorcy4" runat="server" Bold="False"></ea:DataLabel></TD>
								</TR>
								<TR>
									<TD vAlign="middle">
										<TABLE id="Table9" cellSpacing="0" cellPadding="0" border="0">
											<TR>
												<TD style="WIDTH: 45mm; HEIGHT: 8.5mm"></TD>
												<TD style="WIDTH: 30mm" vAlign="top"><STRONG></STRONG></TD>
												<TD style="WIDTH: 60mm" vAlign="top">
													<ea:DataLabel id="DataLabel37" runat="server" Bold="False" DataMember="Kwota"></ea:DataLabel></TD>
											</TR>
										</TABLE>
									</TD>
								</TR>
								<TR>
									<TD style="HEIGHT: 8.5mm" vAlign="top">
										<ea:DataLabel id="rachunekNadawcy4" runat="server" Bold="False"></ea:DataLabel></TD>
								</TR>
								<TR>
									<TD style="HEIGHT: 8.5mm" vAlign="top">
										<ea:DataLabel id="nadawca41" runat="server" Bold="False" DESIGNTIMEDRAGDROP="961"></ea:DataLabel></TD>
								</TR>
								<TR>
									<TD style="HEIGHT: 8.5mm" vAlign="top">
										<ea:DataLabel id="nadawca42" runat="server" Bold="False"></ea:DataLabel></TD>
								</TR>
								<TR>
									<TD style="HEIGHT: 8.5mm" vAlign="top">
										<ea:DataLabel id="opis41" runat="server" Bold="False"></ea:DataLabel></TD>
								</TR>
								<TR>
									<TD style="HEIGHT: 8.5mm" vAlign="top">
										<ea:DataLabel id="opis42" runat="server" Bold="False" DESIGNTIMEDRAGDROP="970"></ea:DataLabel></TD>
								</TR>
								<TR>
									<TD style="HEIGHT: 1mm" vAlign="top">
										<ea:DataLabel id="data4" runat="server" Bold="False"></ea:DataLabel></TD>
									<TD style="HEIGHT: 5.01mm" vAlign="bottom"></TD>
								</TR>
							</TABLE>
						</TD>
					</TR>
				</TABLE>
				<ea:SectionMarker id="SectionMarker8" runat="server" SectionType="Footer"></ea:SectionMarker>
			</ea:datarepeater>
		</form>
	</body>
</HTML>

